<?php
/**
 * Title: Lading page one
 * Slug: theme/page-landing-one
 * Categories: pages
 */
?>

<!-- wp:group {"align":"wide","layout":{"inherit":false},"paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-group alignwide pt__10 pb__10"><!-- wp:cover {"url":"<?php echo get_template_directory_uri(); ?>/assets/images/hero.jpeg","dimRatio":0,"overlayColor":"black","focalPoint":{"x":"0.50","y":"0.50"},"minHeight":58,"minHeightUnit":"vh","isDark":false,"align":"wide","className":"br__s"} -->
<div class="wp-block-cover alignwide is-light br__s" style="min-height:58vh"><span aria-hidden="true" class="wp-block-cover__background has-black-background-color has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background" alt="Hero image" src="<?php echo get_template_directory_uri(); ?>/assets/images/hero.jpeg" style="object-position:50% 50%" data-object-fit="cover" data-object-position="50% 50%"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"700"}},"textColor":"button-color-primary","fontSize":"text-xs"} -->
<p class="has-text-align-center has-button-color-primary-color has-text-color has-text-xs-font-size" style="font-style:normal;font-weight:700;line-height:1"><?php echo esc_html_x( 'The perfect start', 'sample content for Hero pre title', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","textColor":"button-color-primary","fontSize":"text-5-xl","paddingTop":7,"paddingBottom":7} -->
<h2 class="has-text-align-center has-button-color-primary-color has-text-color has-text-5-xl-font-size pt__7 pb__7"><?php echo esc_html_x( 'Morning Rituals', 'sample content for Hero heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:ainoblocks/multiple-buttons {"align":"center"} -->
<div class="wp-block-ainoblocks-multiple-buttons aligncenter"><!-- wp:ainoblocks/button {"mode":true,"size":"size__l","borderRadius":17,"label":"Shop now","className":"is-style-primary"} -->
<div class="wp-block-ainoblocks-button variant is-style-primary" style="border-radius:17px"><a class="wp-block-ainoblocks-button__link size__l 17" style="border-radius:17px"><?php echo esc_html_x( 'Shop now', 'sample content for Hero heading', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( 'Top Rated', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"Shop range","className":"is-style-text"} -->
<div class="wp-block-ainoblocks-button is-style-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius"><?php echo esc_html_x( 'Shop range', 'sample content for text button link', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking">
<!-- wp:woocommerce/product-top-rated {"columns":4,"rows":1,"contentVisibility":{"image":true,"title":true,"price":true,"rating":false,"button":true},"className":"br__s"} /--></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( 'Upcoming arrivals', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"New in store","className":"is-style-text"} -->
<div class="wp-block-ainoblocks-button is-style-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius"><?php echo esc_html_x( 'New in store', 'sample content for text button link', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":7,"gridColumnEndTablet":7,"justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__7 col_start_t__1 col_end_t__7 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking"><!-- wp:woocommerce/featured-category {"dimRatio":10,"editMode":false,"imageFit":"cover","mediaSrc":"<?php echo get_template_directory_uri(); ?>/assets/images/product-cat-01.jpeg","minHeight":790,"categoryId":220,"showDesc":false,"className":"br__s","textColor":"button-color-primary"} -->
<!-- wp:buttons {"lock":{"move":false,"remove":false},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"lock":{"move":false,"remove":false},"style":{"border":{"radius":"12px"}},"className":"btn-s primary-variant"} -->
<div class="wp-block-button btn-s primary-variant"><a class="wp-block-button__link wp-element-button" href="#" style="border-radius:12px"><?php echo esc_html_x( 'Shop now', 'sample content for button link', 'mugistore' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- /wp:woocommerce/featured-category --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":7,"gridColumnEndDesktop":13,"gridColumnStartTablet":7,"justifyItem":"stretch","justifyItemTablet":"center","marginTopTablet":0,"marginTopMobile":3} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__7 col_end_d__13 col_start_t__7 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch js__t__center no-stacking mt_t__0 mt_m__3"><!-- wp:woocommerce/featured-category {"dimRatio":10,"editMode":false,"imageFit":"cover","mediaSrc":"<?php echo get_template_directory_uri(); ?>/assets/images/product-cat-02.jpeg","minHeight":794,"categoryId":220,"showDesc":false,"className":"br__s","textColor":"button-color-primary"} -->
<!-- wp:buttons {"lock":{"move":false,"remove":false},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"border":{"radius":"12px"}},"className":"btn-s primary-variant"} -->
<div class="wp-block-button btn-s primary-variant"><a class="wp-block-button__link wp-element-button" href="#" style="border-radius:12px"><?php echo esc_html_x( 'Shop now', 'sample content for button link', 'mugistore' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- /wp:woocommerce/featured-category --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:group {"align":"wide","layout":{"type":"default"},"paddingTop":10} -->
<div class="wp-block-group alignwide pt__10">
<!-- wp:heading {"textAlign":"center","textColor":"font-tertiary","fontSize":"text-xs"} -->
<h2 class="has-text-align-center has-font-tertiary-color has-text-color has-text-xs-font-size"><?php echo esc_html_x( 'We work with the following brands', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:ainoblocks/flexbox {"flexDirectionMobile":"direction__col__m","justifyContentDesktop":"justify__center__d","justifyContentTablet":"justify__center__t","justifyContentMobile":"justify__center__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m","alignContentDesktop":"align-cont__center__d","alignContentTablet":"align-cont__center__t","paddingTop":8} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__col__m nowrap__d nowrap_t nowrap_m justify__center__d justify__center__t justify__center__m align-items__center__d align-items__center__t align-items__center__m align-cont__center__d align-cont__center__t align-cont__stretch__m shadow-none pt__8"><!-- wp:image {"width":177,"height":32,"sizeSlug":"full","linkDestination":"none","paddingBottom":11,"paddingLeft":8,"paddingRight":8} -->
<figure class="wp-block-image size-full is-resized pb__11 pl__8 pr__8"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/brand1.png" alt="Brand image" width="177" height="32"/></figure>
<!-- /wp:image -->

<!-- wp:image {"width":135,"height":32,"sizeSlug":"full","linkDestination":"none","paddingBottom":11,"paddingLeft":8,"paddingRight":8} -->
<figure class="wp-block-image size-full is-resized pb__11 pl__8 pr__8"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/brand2.png" alt="Brand image" width="135" height="32"/></figure>
<!-- /wp:image -->

<!-- wp:image {"width":143,"height":32,"sizeSlug":"full","linkDestination":"none","paddingBottom":11,"paddingLeft":8,"paddingRight":8} -->
<figure class="wp-block-image size-full is-resized pb__11 pl__8 pr__8"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/brand3.png" alt="Brand image" width="143" height="32"/></figure>
<!-- /wp:image -->

<!-- wp:image {"width":124,"height":32,"sizeSlug":"full","linkDestination":"none","paddingBottom":11,"paddingLeft":8,"paddingRight":8} -->
<figure class="wp-block-image size-full is-resized pb__11 pl__8 pr__8"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/brand4.png" alt="Brand image" width="124" height="32"/></figure>
<!-- /wp:image -->

<!-- wp:image {"width":168,"height":32,"sizeSlug":"full","linkDestination":"none","paddingBottom":11,"paddingLeft":8,"paddingRight":8} -->
<figure class="wp-block-image size-full is-resized pb__11 pl__8 pr__8"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/brand5.png" alt="Brand image" width="168" height="32"/></figure>
<!-- /wp:image -->

<!-- wp:image {"width":175,"height":32,"sizeSlug":"full","linkDestination":"none","paddingBottom":11,"paddingLeft":8,"paddingRight":8} -->
<figure class="wp-block-image size-full is-resized pb__11 pl__8 pr__8"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/brand6.png" alt="Brand image" width="175" height="32"/></figure>
<!-- /wp:image -->
</div>
<!-- /wp:ainoblocks/flexbox -->
</div>
<!-- /wp:group -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( 'Top Rated', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"Shop range","className":"is-style-text"} -->
<div class="wp-block-ainoblocks-button is-style-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius"><?php echo esc_html_x( 'Shop range', 'sample content for text button link', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking">
<!-- wp:woocommerce/product-top-rated {"columns":4,"rows":1,"contentVisibility":{"image":true,"title":true,"price":true,"rating":false,"button":true},"className":"br__s"} /--></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( 'Join us', 'sample content for CTA heading', 'mugistore' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking"><!-- wp:cover {"url":"<?php echo get_template_directory_uri(); ?>/assets/images/banner-bg.png","id":217,"dimRatio":0,"minHeight":248,"isDark":false,"className":"br__m"} -->
<div class="wp-block-cover is-light br__m" style="min-height:248px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-217" alt="WooCommerce block theme Mugistore banner" src="<?php echo get_template_directory_uri(); ?>/assets/images/banner-bg.png" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:ainoblocks/card {"borderRadius":"xs","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__xs"><!-- wp:heading {"fontSize":"text-xxl","paddingTop":1} -->
<h2 class="has-text-xxl-font-size pt__1"><?php echo esc_html_x( 'Join our Monthly Tea Lovers Club', 'sample content for CTA heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":3,"paddingBottom":6} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__3 pb__6"><?php echo esc_html_x( 'Join our Mugi-cha tea lovers membership community.', 'sample content for CTA text', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:ainoblocks/multiple-buttons {"align":"left","gapDesktop":true} -->
<div class="wp-block-ainoblocks-multiple-buttons alignleft d__gap"><!-- wp:ainoblocks/button {"size":"size__s","borderRadius":12,"label":"Join us today","className":"is-style-neutral-primary"} -->
<div class="wp-block-ainoblocks-button is-style-neutral-primary" style="border-radius:12px"><a class="wp-block-ainoblocks-button__link size__s 12" href="#" style="border-radius:12px"><?php echo esc_html_x( 'Join us today', 'sample content for CTA button text', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/card --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:ainoblocks/flex-item -->
<div class="wp-block-ainoblocks-flex-item auto"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( '5 Star Reviews', 'sample content for section heading', 'mugistore' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item -->
<div class="wp-block-ainoblocks-flex-item auto"><!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"Shop with confidence","className":"is-style-neutral-text"} -->
<div class="wp-block-ainoblocks-button is-style-neutral-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius" href="#"><?php echo esc_html_x( 'Shop with confidence', 'sample content for text button link', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flex-item --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":5,"gridColumnStartTablet":1,"gridColumnEndTablet":5,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","backgroundColor":"background-secondary","borderRadius":"xs"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__5 col_start_t__1 col_end_t__5 col_start_m__1 col_end_m__13 align-self__stretch justify-self__stretch no-stacking has-background-secondary-background-color has-background br-all__xs"><!-- wp:ainoblocks/testimonial {"style":"indent-none","paddingBottom":1} -->
<div class="wp-block-ainoblocks-testimonial indent-none pb__1"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10,"className":"relative"} -->
<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 relative br-all__none"><!-- wp:image {"align":"center","id":256,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded no-lineheight"} -->
<figure class="wp-block-image aligncenter size-full is-resized is-style-rounded no-lineheight"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/testimonial-01.jpeg" alt="" class="wp-image-256" width="80" height="80"/></figure>
<!-- /wp:image -->

<!-- wp:image {"align":"center","id":50,"width":80,"height":16,"sizeSlug":"full","linkDestination":"none","className":"no-lineheight","paddingTop":7} -->
<figure class="wp-block-image aligncenter size-full is-resized no-lineheight pt__7"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/rating.png" alt="five star rating" class="wp-image-50" width="80" height="16"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center","placeholder":"Write testimonial text...","fontSize":"text-xs","paddingTop":7,"paddingBottom":1,"paddingLeft":0,"paddingRight":0} -->
<p class="has-text-align-center has-text-xs-font-size pt__7 pb__1"><?php echo esc_html_x( '“If you want to live your life in a creative way, as an artist, you have to not look back too much. You have to be willing to take whatever you’ve done and whoever.”', 'sample content for testimonial', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","placeholder":"Write testimonial text...","textColor":"font-tertiary","fontSize":"text-xs","paddingTop":7,"paddingBottom":1,"paddingLeft":0,"paddingRight":0} -->
<p class="has-text-align-center has-font-tertiary-color has-text-color has-text-xs-font-size pt__7 pb__1"><?php echo esc_html_x( 'Amila Williams', 'sample content for testimonial author', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/testimonial --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":5,"gridColumnEndDesktop":9,"gridColumnStartTablet":5,"gridColumnEndTablet":9,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopTablet":0,"marginTopMobile":4,"backgroundColor":"background-secondary","borderRadius":"xs"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__5 col_end_d__9 col_start_t__5 col_end_t__9 col_start_m__1 col_end_m__13 align-self__stretch justify-self__stretch no-stacking mt_t__0 mt_m__4 has-background-secondary-background-color has-background br-all__xs"><!-- wp:ainoblocks/testimonial {"style":"indent-none","paddingBottom":1} -->
<div class="wp-block-ainoblocks-testimonial indent-none pb__1"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10,"className":"relative"} -->
<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 relative br-all__none"><!-- wp:image {"align":"center","id":261,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded no-lineheight"} -->
<figure class="wp-block-image aligncenter size-full is-resized is-style-rounded no-lineheight"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/testimonial-03.jpeg" alt="" class="wp-image-261" width="80" height="80"/></figure>
<!-- /wp:image -->

<!-- wp:image {"align":"center","id":50,"width":80,"height":16,"sizeSlug":"full","linkDestination":"none","className":"no-lineheight","paddingTop":7} -->
<figure class="wp-block-image aligncenter size-full is-resized no-lineheight pt__7"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/rating.png" alt="five star rating" class="wp-image-50" width="80" height="16"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center","placeholder":"Write testimonial text...","fontSize":"text-xs","paddingTop":7,"paddingBottom":1,"paddingLeft":0,"paddingRight":0} -->
<p class="has-text-align-center has-text-xs-font-size pt__7 pb__1"><?php echo esc_html_x( '“If you want to live your life in a creative way, as an artist, you have to not look back too much. You have to be willing to take whatever you’ve done and whoever you were”', 'sample content for testimonial', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","placeholder":"Write testimonial text...","textColor":"font-tertiary","fontSize":"text-xs","paddingTop":7,"paddingBottom":1,"paddingLeft":0,"paddingRight":0} -->
<p class="has-text-align-center has-font-tertiary-color has-text-color has-text-xs-font-size pt__7 pb__1"><?php echo esc_html_x( 'Liz Rossi', 'sample content for testimonial author', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/testimonial --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":9,"gridColumnEndDesktop":13,"gridColumnStartTablet":9,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopDesktop":0,"marginTopTablet":0,"marginTopMobile":5,"backgroundColor":"background-secondary","borderRadius":"xs","paddingTop":1} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__9 col_end_d__13 col_start_t__9 col_end_t__13 col_start_m__1 col_end_m__13 align-self__stretch justify-self__stretch no-stacking mt_d__0 mt_t__0 mt_m__5 has-background-secondary-background-color has-background br-all__xs pt__1"><!-- wp:ainoblocks/testimonial {"style":"indent-none","paddingBottom":1} -->
<div class="wp-block-ainoblocks-testimonial indent-none pb__1"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10,"className":"relative"} -->
<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 relative br-all__none"><!-- wp:image {"align":"center","id":258,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none","className":"is-style-rounded no-lineheight"} -->
<figure class="wp-block-image aligncenter size-full is-resized is-style-rounded no-lineheight"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/testimonial-02.jpeg" alt="" class="wp-image-258" width="80" height="80"/></figure>
<!-- /wp:image -->

<!-- wp:image {"align":"center","id":50,"width":80,"height":16,"sizeSlug":"full","linkDestination":"none","className":"no-lineheight","paddingTop":7} -->
<figure class="wp-block-image aligncenter size-full is-resized no-lineheight pt__7"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/rating.png" alt="five star rating" class="wp-image-50" width="80" height="16"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center","placeholder":"Write testimonial text...","fontSize":"text-xs","paddingTop":7,"paddingBottom":1,"paddingLeft":0,"paddingRight":0} -->
<p class="has-text-align-center has-text-xs-font-size pt__7 pb__1"><?php echo esc_html_x( '“If you want to live your life in a creative way, as an artist, you have to not look back too much.”', 'sample content for testimonial', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","placeholder":"Write testimonial text...","textColor":"font-tertiary","fontSize":"text-xs","paddingTop":7,"paddingBottom":1,"paddingLeft":0,"paddingRight":0} -->
<p class="has-text-align-center has-font-tertiary-color has-text-color has-text-xs-font-size pt__7 pb__1"><?php echo esc_html_x( 'Jo Wang', 'sample content for testimonial author', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/testimonial --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( 'Featured categories', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"Shop all","className":"is-style-text"} -->
<div class="wp-block-ainoblocks-button is-style-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius"><?php echo esc_html_x( 'Shop all', 'sample content for text button link', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":7,"gridColumnEndTablet":7,"justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__7 col_start_t__1 col_end_t__7 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking"><!-- wp:woocommerce/featured-category {"dimRatio":10,"editMode":false,"imageFit":"cover","mediaSrc":"<?php echo get_template_directory_uri(); ?>/assets/images/product-cat-05.jpeg","minHeight":1153,"categoryId":220,"showDesc":false,"className":"br__s","textColor":"button-color-primary"} -->
<!-- wp:buttons {"lock":{"move":false,"remove":false},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"lock":{"move":false,"remove":false},"style":{"border":{"radius":"12px"}},"className":"btn-s primary-variant"} -->
<div class="wp-block-button btn-s primary-variant"><a class="wp-block-button__link wp-element-button" href="#/" style="border-radius:12px"><?php echo esc_html_x( 'Shop now', 'sample content for button link', 'mugistore' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- /wp:woocommerce/featured-category --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":7,"gridColumnEndDesktop":13,"gridColumnStartTablet":7,"justifyItem":"stretch","justifyItemTablet":"stretch","justifyItemMobile":"stretch","marginTopTablet":0,"marginTopMobile":3} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__7 col_end_d__13 col_start_t__7 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch js__t__stretch js__m__stretch no-stacking mt_t__0 mt_m__3"><!-- wp:ainoblocks/flexbox {"flexDirectionDesktop":"direction__col__d","flexDirectionTablet":"direction__col__t","flexDirectionMobile":"direction__col__m","alignContentDesktop":"align-cont__flexstart__d"} -->
<div class="wp-block-ainoblocks-flexbox direction__col__d direction__col__t direction__col__m nowrap__d nowrap_t nowrap_m justify__flexstart__d justify__flexstart__t justify__flexstart__m align-items__stretch__d align-items__stretch__t align-itms__stretch__m align-cont__flexstart__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:ainoblocks/flex-item -->
<div class="wp-block-ainoblocks-flex-item auto"><!-- wp:woocommerce/featured-category {"dimRatio":10,"editMode":false,"imageFit":"cover","mediaSrc":"<?php echo get_template_directory_uri(); ?>/assets/images/product-cat-04.jpeg","minHeight":579,"categoryId":220,"showDesc":false,"className":"br__s","textColor":"button-color-primary"} -->
<!-- wp:buttons {"lock":{"move":false,"remove":false},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"border":{"radius":"12px"}},"className":"primary-variant is-style-fill"} -->
<div class="wp-block-button primary-variant is-style-fill"><a class="wp-block-button__link wp-element-button" href="#" style="border-radius:12px"><?php echo esc_html_x( 'New arrivals', 'sample content for button link', 'mugistore' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- /wp:woocommerce/featured-category --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingTop":5} -->
<div class="wp-block-ainoblocks-flex-item auto pt__5"><!-- wp:woocommerce/featured-category {"dimRatio":10,"editMode":false,"imageFit":"cover","mediaId":25911,"mediaSrc":"<?php echo get_template_directory_uri(); ?>/assets/images/product-cat-03.jpeg","minHeight":557,"categoryId":220,"overlayColor":"#FFFFFF","showDesc":false,"className":"br__s","textColor":"button-color-primary"} -->
<!-- wp:buttons {"lock":{"move":false,"remove":false},"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"border":{"radius":"12px"}},"className":"primary-variant is-style-fill"} -->
<div class="wp-block-button primary-variant is-style-fill"><a class="wp-block-button__link wp-element-button" href="#" style="border-radius:12px"><?php echo esc_html_x( 'Discover', 'sample content for button link', 'mugistore' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->
<!-- /wp:woocommerce/featured-category --></div>
<!-- /wp:ainoblocks/flex-item --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-m","paddingTop":10,"paddingBottom":13} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-m pt__10 pb__13"><!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":4,"gridColumnEndDesktop":10,"gridColumnStartTablet":1,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"stretch","className":"align-self__start","paddingTop":1} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__4 col_end_d__10 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking align-self__start pt__1"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php echo esc_html_x( 'Frequently asked questions', 'sample content for FAQ', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","fontSize":"text-xs","paddingTop":3,"paddingBottom":10} -->
<p class="has-text-align-center has-text-xs-font-size pt__3 pb__10"><?php echo esc_html_x( 'We want to answer all your questions.', 'sample content for FAQ', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:ainoblocks/accordion-faq-block {"backgroundColor":"background-secondary","borderRadius":"xs","question":"What is your favourite type of tea?","style":{"border":{"width":"0px","style":"none"}},"className":"br__xs","paddingTop":7,"paddingBottom":7,"paddingLeft":7,"paddingRight":7} -->
<div class="wp-block-ainoblocks-accordion-faq-block icon__right br__xs has-background-secondary-background-color has-background br-all__xs pt__7 pb__7 pl__7 pr__7" style="border-style:none;border-width:0px" x-data="{ open: false }" @click="open = !open" :class="{'open': open, 'close': ! open }"><div class="accordion"><h3 class="has-xxs-font-size"><?php echo esc_html_x( 'What is your favourite type of tea?', 'sample content for FAQ', 'mugistore' ); ?></h3></div><div class="panel"><!-- wp:paragraph {"placeholder":"Write an answer ...","textColor":"font-secondary","fontSize":"text-xs","paddingTop":7} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__7"><?php echo esc_html_x( 'We understand that, sometimes there are circumstances where you need to exchange or return your purchase. Unfortunately we do not currently offer free shipping for returns or exchanges, but we do cover the cost of shipping for returns on any items purchased via our website or mobile app.', 'sample content for FAQ', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:ainoblocks/accordion-faq-block -->

<!-- wp:ainoblocks/accordion-faq-block {"backgroundColor":"background-secondary","borderRadius":"xs","question":"What is one book you would recommend to everyone?","style":{"border":{"width":"0px","style":"none"}},"className":"br__xs","paddingTop":7,"paddingBottom":7,"paddingLeft":7,"paddingRight":7} -->
<div class="wp-block-ainoblocks-accordion-faq-block icon__right br__xs has-background-secondary-background-color has-background br-all__xs pt__7 pb__7 pl__7 pr__7" style="border-style:none;border-width:0px" x-data="{ open: false }" @click="open = !open" :class="{'open': open, 'close': ! open }"><div class="accordion"><h3 class="has-xxs-font-size"><?php echo esc_html_x( 'What is one book you would recommend to everyone?', 'sample content for FAQ', 'mugistore' ); ?></h3></div><div class="panel"><!-- wp:paragraph {"placeholder":"Write an answer ...","textColor":"font-secondary","fontSize":"text-xs","paddingTop":7} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__7"><?php echo esc_html_x( 'we love tea and want to share it with you. all our teas are expertly sourced, tasting delicious and packed full of health benefits. we tried them all by ourselves first, so you know they are top notch - just like we promise.', 'sample content for FAQ', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:ainoblocks/accordion-faq-block -->

<!-- wp:ainoblocks/accordion-faq-block {"backgroundColor":"background-secondary","borderRadius":"xs","question":"How long can items be returned?","style":{"border":{"width":"0px","style":"none"}},"className":"br__xs","paddingTop":7,"paddingBottom":7,"paddingLeft":7,"paddingRight":7} -->
<div class="wp-block-ainoblocks-accordion-faq-block icon__right br__xs has-background-secondary-background-color has-background br-all__xs pt__7 pb__7 pl__7 pr__7" style="border-style:none;border-width:0px" x-data="{ open: false }" @click="open = !open" :class="{'open': open, 'close': ! open }"><div class="accordion"><h3 class="has-xxs-font-size"><?php echo esc_html_x( 'How long can items be returned?', 'sample content for FAQ', 'mugistore' ); ?></h3></div><div class="panel"><!-- wp:paragraph {"placeholder":"Write an answer ...","textColor":"font-secondary","fontSize":"text-xs","paddingTop":7} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__7"><?php echo esc_html_x( 'You can return your item within 30 days of purchase.', 'sample content for FAQ', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:ainoblocks/accordion-faq-block -->

<!-- wp:ainoblocks/accordion-faq-block {"backgroundColor":"background-secondary","borderRadius":"xs","question":"How long do I need to wait for my order to arrive?","style":{"border":{"width":"0px","style":"none"}},"className":"br__xs","paddingTop":7,"paddingBottom":7,"paddingLeft":7,"paddingRight":7} -->
<div class="wp-block-ainoblocks-accordion-faq-block icon__right br__xs has-background-secondary-background-color has-background br-all__xs pt__7 pb__7 pl__7 pr__7" style="border-style:none;border-width:0px" x-data="{ open: false }" @click="open = !open" :class="{'open': open, 'close': ! open }"><div class="accordion"><h3 class="has-xxs-font-size"><?php echo esc_html_x( 'How long do I need to wait for my order to arrive?', 'sample content for FAQ', 'mugistore' ); ?></h3></div><div class="panel"><!-- wp:paragraph {"placeholder":"Write an answer ...","textColor":"font-secondary","fontSize":"text-xs","paddingTop":7} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__7"><?php echo esc_html_x( 'We typically ship orders within 1-3 business days. As soon as we receive an order, we will notify you via email with a tracking number so you can keep up-to-date on its status.', 'sample content for FAQ', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:ainoblocks/accordion-faq-block -->

<!-- wp:ainoblocks/accordion-faq-block {"backgroundColor":"background-secondary","borderRadius":"xs","question":"Do you have sales or discounts?","style":{"border":{"width":"0px","style":"none"}},"className":"br__xs","paddingTop":7,"paddingBottom":7,"paddingLeft":7,"paddingRight":7} -->
<div class="wp-block-ainoblocks-accordion-faq-block icon__right br__xs has-background-secondary-background-color has-background br-all__xs pt__7 pb__7 pl__7 pr__7" style="border-style:none;border-width:0px" x-data="{ open: false }" @click="open = !open" :class="{'open': open, 'close': ! open }"><div class="accordion"><h3 class="has-xxs-font-size"><?php echo esc_html_x( 'Do you have sales or discounts?', 'sample content for FAQ', 'mugistore' ); ?></h3></div><div class="panel"><!-- wp:paragraph {"placeholder":"Write an answer ...","textColor":"font-secondary","fontSize":"text-xs","paddingTop":7} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__7"><?php echo esc_html_x( 'Yes of course, we have regular specials and sales. Just sign up for our newsletter and Like us on Instagram to hear about our sales first.', 'sample content for FAQ', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div></div>
<!-- /wp:ainoblocks/accordion-faq-block --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:group {"align":"full","backgroundColor":"background-secondary","layout":{"type":"default"},"paddingTop":13,"paddingBottom":13} -->
<div class="wp-block-group alignfull has-background-secondary-background-color has-background pt__13 pb__13"><!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-m"} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-m"><!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":8,"gridColumnEndDesktop":12,"gridColumnStartTablet":7,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"center","justifyItem":"center"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__8 col_end_d__12 col_start_t__7 col_end_t__13 col_start_m__1 col_end_m__13 align-self__center justify-self__center no-stacking"><!-- wp:ainoblocks/card {"paddingBottom":0,"paddingLeft":10,"paddingRight":10,"className":"shadow-none pl__10 pr__10"} -->
<div class="wp-block-ainoblocks-card shadow-none pt__7 pl__10 pr__10"><!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__1"><?php echo esc_html_x( 'Gift vouchers', 'sample content for Features pre title', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}},"textColor":"font-primary","fontSize":"text-xxl","paddingTop":3} -->
<h2 class="has-font-primary-color has-text-color has-text-xxl-font-size pt__3" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0"><?php echo esc_html_x( 'Treat your friends', 'sample content for features heading', 'mugistore' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":5,"paddingRight":0} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__5"><?php echo esc_html_x( 'Are you looking for a gift but are not sure what to purchase? Then make your friends happy with a Mugicha tea gift voucher.', 'sample content for features text', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:ainoblocks/multiple-buttons {"items":1,"paddingTop":7} -->
<div class="wp-block-ainoblocks-multiple-buttons pt__7"><!-- wp:ainoblocks/button {"borderRadius":12,"label":"Shop now","className":"is-style-primary"} -->
<div class="wp-block-ainoblocks-button is-style-primary" style="border-radius:12px"><a class="wp-block-ainoblocks-button__link size__m 12" href="#" style="border-radius:12px"><?php echo esc_html_x( 'Shop now', 'sample content for features link text', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":7,"gridColumnStartTablet":1,"gridColumnEndTablet":7,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"marginTopTablet":0,"marginTopMobile":8,"className":"align-self__start justify-self__start"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__7 col_start_t__1 col_end_t__7 col_start_m__1 col_end_m__13 no-stacking mt_t__0 mt_m__8 align-self__start justify-self__start"><!-- wp:image {"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"20px"}},"className":"has-custom-border size-full is-style-default"} -->
<figure class="wp-block-image size-large has-custom-border size-full is-style-default"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/giftcard.png" alt="Mugistore WooCommerce block theme" style="border-radius:20px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container --></div>
<!-- /wp:group -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":13,"paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__13 pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch","paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking pb__7"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:ainoblocks/flex-item -->
<div class="wp-block-ainoblocks-flex-item auto"><!-- wp:heading {"fontSize":"text-l"} -->
<h2 class="has-text-l-font-size"><?php echo esc_html_x( 'From the blog', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item -->
<div class="wp-block-ainoblocks-flex-item auto"><!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"Read all","className":"is-style-text"} -->
<div class="wp-block-ainoblocks-button is-style-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius"><?php echo esc_html_x( 'Read all', 'sample content for text button link', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flex-item --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking"><!-- wp:query {"queryId":4,"query":{"perPage":"3","pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"exclude","inherit":false},"tagName":"section","displayLayout":{"type":"flex","columns":3},"align":"wide","className":"gap-s","layout":{"inherit":false}} -->
<section class="wp-block-query alignwide gap-s"><!-- wp:post-template -->
<!-- wp:post-featured-image {"isLink":true,"className":"br__s"} /-->

<!-- wp:post-terms {"term":"category","textColor":"font-tertiary","fontSize":"text-xxs"} /-->

<!-- wp:post-title {"level":3,"isLink":true,"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"text-m"} /-->
<!-- /wp:post-template --></section>
<!-- /wp:query --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingTop":10,"paddingBottom":7} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pt__10 pb__7"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":13,"gridColumnEndTablet":13,"alignItem":"stretch","justifyItem":"stretch"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 align-self__stretch justify-self__stretch no-stacking"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__between__d","justifyContentTablet":"justify__between__t","justifyContentMobile":"justify__between__m","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__between__d justify__between__t justify__between__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:ainoblocks/flexbox -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__flexstart__d justify__flexstart__t justify__flexstart__m align-items__stretch__d align-items__stretch__t align-itms__stretch__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:heading {"textAlign":"left","fontSize":"text-l"} -->
<h2 class="has-text-align-left has-text-l-font-size"><?php echo esc_html_x( 'Follow us', 'sample content for heading', 'mugistore' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:ainoblocks/flexbox -->

<!-- wp:ainoblocks/multiple-buttons -->
<div class="wp-block-ainoblocks-multiple-buttons"><!-- wp:ainoblocks/button {"label":"@mugistoretheme","className":"is-style-neutral-text"} -->
<div class="wp-block-ainoblocks-button is-style-neutral-text"><a class="wp-block-ainoblocks-button__link size__m no-border-radius" href="#"><?php echo esc_html_x( '@mugistoretheme', 'sample content for link text', 'mugistore' ); ?></a></div>
<!-- /wp:ainoblocks/button --></div>
<!-- /wp:ainoblocks/multiple-buttons --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->


<!-- wp:group {"align":"full","backgroundColor":"background-primary","layout":{"type":"default"}} -->
<div class="wp-block-group alignfull has-background-primary-background-color has-background"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__evenly__d"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__evenly__d justify__flexstart__t justify__flexstart__m align-items__stretch__d align-items__stretch__t align-itms__stretch__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:ainoblocks/flex-item {"flexBasis":""} -->
<div class="wp-block-ainoblocks-flex-item auto"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/insta-07.jpeg" alt="Image"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"flexGrow":1} -->
<div class="wp-block-ainoblocks-flex-item auto" style="flex-grow:1"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/insta-01.png" alt="Image"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"flexGrow":1} -->
<div class="wp-block-ainoblocks-flex-item auto" style="flex-grow:1"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/insta-02.jpeg" alt="Image"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"flexGrow":1,"alignSelfDesktop":"align__stretch__d","className":"mobile-hide tablet-show"} -->
<div class="wp-block-ainoblocks-flex-item align__stretch__d auto mobile-hide tablet-show" style="flex-grow:1"></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"flexGrow":1,"className":"mobile-hide tablet-show"} -->
<div class="wp-block-ainoblocks-flex-item auto mobile-hide tablet-show" style="flex-grow:1"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/insta-03.jpeg" alt="Image"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"flexGrow":1,"className":"mobile-hide tablet-show"} -->
<div class="wp-block-ainoblocks-flex-item auto mobile-hide tablet-show" style="flex-grow:1"><!-- wp:image {"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/insta-05.jpeg" alt="Image"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"flexGrow":1,"className":"mobile-hide desktop-show"} -->
<div class="wp-block-ainoblocks-flex-item auto mobile-hide desktop-show" style="flex-grow:1"><!-- wp:image {sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/insta-06.png" alt="Image"/></figure>
<!-- /wp:image --></div>
<!-- /wp:ainoblocks/flex-item --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:group -->


<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"default"},"paddingTop":6,"paddingBottom":6} -->
<div class="wp-block-group alignwide pt__6 pb__6">

<!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s"} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s"><!-- wp:ainoblocks/grid-item {"gridColumnEndDesktop":4,"gridColumnEndTablet":4,"gridColumnEndMobile":7,"alignItem":"center","justifyItem":"stretch","paddingBottom":1} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__4 col_start_t__1 col_end_t__4 col_start_m__1 col_end_m__7 align-self__center justify-self__stretch no-stacking pb__1"><!-- wp:ainoblocks/icon {"iconType":"Truck","iconSize":"size-s","alignment":"center"} -->
<div class="wp-block-ainoblocks-icon Truck size-s center"><svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M23.249 11.262v-0.013c0-0.007 0-0.012-0.001-0.019 0-0.017-0.001-0.034-0.003-0.051-0.001-0.010-0.003-0.021-0.004-0.032-0.002-0.013-0.004-0.027-0.007-0.040s-0.007-0.028-0.009-0.041c-0.003-0.009-0.005-0.020-0.008-0.029-0.005-0.017-0.011-0.033-0.017-0.050-0.002-0.006-0.004-0.011-0.006-0.017l-0.005-0.011v-0.003l-1.307-3.263c-0.223-0.565-0.779-0.943-1.382-0.943h-3.253v-0.75c0-0.414-0.336-0.75-0.75-0.75h-14.249c-0.827-0.001-1.5 0.672-1.5 1.499v10.5c0 0.827 0.673 1.5 1.5 1.5h1.22c0.334 1.293 1.509 2.25 2.905 2.25s2.571-0.957 2.905-2.25h5.44c0.334 1.293 1.509 2.25 2.905 2.25s2.571-0.957 2.905-2.25h1.22c0.827 0 1.5-0.673 1.5-1.5v-5.987h-0.001zM20.491 8.249l0.9 2.25h-4.142v-2.25h3.242zM15.749 6.749v6h-13.499v-6h13.499zM15.749 14.249v1.411c-0.498 0.399-0.866 0.953-1.030 1.589h-5.44c-0.334-1.293-1.509-2.25-2.905-2.25s-2.571 0.957-2.905 2.25h-1.22v-3h13.5zM6.375 19.498c-0.827 0-1.5-0.673-1.5-1.5s0.673-1.5 1.5-1.5 1.5 0.673 1.5 1.5c0 0.827-0.673 1.5-1.5 1.5zM17.624 19.498c-0.827 0-1.5-0.673-1.5-1.5s0.673-1.5 1.5-1.5c0.827 0 1.5 0.673 1.5 1.5s-0.673 1.5-1.5 1.5zM21.749 17.249h-1.22c-0.334-1.293-1.509-2.25-2.905-2.25-0.128 0-0.252 0.008-0.375 0.024v-3.024h4.5v5.25z"></path></svg></div>
<!-- /wp:ainoblocks/icon -->

<!-- wp:paragraph {"align":"center","fontSize":"text-xs","paddingTop":4} -->
<p class="has-text-align-center has-text-xs-font-size pt__4"><?php echo esc_html_x( 'Free shipping*', 'sample content for Icon with text', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":4,"gridColumnEndDesktop":7,"gridColumnStartTablet":4,"gridColumnEndTablet":7,"gridColumnStartMobile":7,"alignItem":"center","justifyItem":"stretch","marginTopMobile":0,"paddingBottom":1} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__4 col_end_d__7 col_start_t__4 col_end_t__7 col_start_m__7 col_end_m__13 align-self__center justify-self__stretch no-stacking mt_m__0 pb__1"><!-- wp:ainoblocks/icon {"iconType":"Swap","iconSize":"size-s","alignment":"center"} -->
<div class="wp-block-ainoblocks-icon Swap size-s center"><svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M7.939 3.439c0.281-0.281 0.663-0.439 1.061-0.439h10.5c0.398 0 0.779 0.158 1.061 0.439s0.439 0.663 0.439 1.061v9.75c0 0.398-0.158 0.779-0.439 1.061s-0.663 0.439-1.061 0.439h-12c-0.414 0-0.75-0.336-0.75-0.75s0.336-0.75 0.75-0.75h12v-9.75h-10.5v0.75c0 0.414-0.336 0.75-0.75 0.75s-0.75-0.336-0.75-0.75v-0.75c0-0.398 0.158-0.779 0.439-1.061z"></path><path d="M10.28 12.22c0.293 0.293 0.293 0.768 0 1.061l-1.72 1.72 1.72 1.72c0.293 0.293 0.293 0.768 0 1.061s-0.768 0.293-1.061 0l-2.25-2.25c-0.293-0.293-0.293-0.768 0-1.061l2.25-2.25c0.293-0.293 0.768-0.293 1.061 0z"></path><path d="M3.439 8.689c0.281-0.281 0.663-0.439 1.061-0.439h12c0.414 0 0.75 0.336 0.75 0.75s-0.336 0.75-0.75 0.75h-12v9.75h10.5v-0.75c0-0.414 0.336-0.75 0.75-0.75s0.75 0.336 0.75 0.75v0.75c0 0.398-0.158 0.779-0.439 1.061s-0.663 0.439-1.061 0.439h-10.5c-0.398 0-0.779-0.158-1.061-0.439s-0.439-0.663-0.439-1.061v-9.75c0-0.398 0.158-0.779 0.439-1.061z"></path><path d="M13.72 6.22c0.293-0.293 0.768-0.293 1.061 0l2.25 2.25c0.293 0.293 0.293 0.768 0 1.061l-2.25 2.25c-0.293 0.293-0.768 0.293-1.061 0s-0.293-0.768 0-1.061l1.72-1.72-1.72-1.72c-0.293-0.293-0.293-0.768 0-1.061z"></path></svg></div>
<!-- /wp:ainoblocks/icon -->

<!-- wp:paragraph {"align":"center","fontSize":"text-xs","paddingTop":4} -->
<p class="has-text-align-center has-text-xs-font-size pt__4"><?php echo esc_html_x( 'Easy Returns', 'sample content for Icon with text', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":7,"gridColumnEndDesktop":10,"gridColumnStartTablet":7,"gridColumnEndTablet":10,"gridColumnEndMobile":7,"alignItem":"center","justifyItem":"stretch","marginTopTablet":0,"marginTopMobile":4,"paddingBottom":1} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__7 col_end_d__10 col_start_t__7 col_end_t__10 col_start_m__1 col_end_m__7 align-self__center justify-self__stretch no-stacking mt_t__0 mt_m__4 pb__1"><!-- wp:ainoblocks/icon {"iconType":"TShirt","iconSize":"size-s","alignment":"center"} -->
<div class="wp-block-ainoblocks-icon TShirt size-s center"><svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M23.228 5.742l-4.726-2.644c0 0-0.004-0.002-0.006-0.003-0.015-0.008-0.031-0.016-0.046-0.023-0.008-0.004-0.015-0.007-0.023-0.010-0.014-0.006-0.029-0.011-0.043-0.016-0.010-0.004-0.019-0.007-0.029-0.010-0.011-0.004-0.023-0.007-0.035-0.009-0.013-0.004-0.027-0.007-0.039-0.010-0.009-0.002-0.017-0.003-0.026-0.005-0.017-0.003-0.033-0.006-0.051-0.007-0.007 0-0.014 0-0.021-0.002-0.018-0.002-0.036-0.003-0.055-0.003-0.002 0-0.004 0-0.006 0h-3.061c-0.423 0-0.765 0.336-0.765 0.75 0 1.24-1.030 2.25-2.296 2.25s-2.296-1.010-2.296-2.25c0-0.414-0.343-0.75-0.765-0.75h-3.061c0 0-0.005 0-0.007 0-0.016 0-0.033 0.001-0.049 0.003-0.010 0-0.018 0-0.028 0.002-0.014 0.002-0.029 0.004-0.044 0.007-0.011 0.002-0.022 0.003-0.033 0.006s-0.022 0.006-0.033 0.008c-0.013 0.004-0.028 0.007-0.041 0.011-0.009 0.003-0.016 0.006-0.024 0.008-0.016 0.006-0.032 0.011-0.048 0.018-0.007 0.003-0.014 0.007-0.021 0.010-0.016 0.008-0.032 0.015-0.048 0.023-0.002 0.001-0.004 0.002-0.006 0.003l-4.729 2.645c-0.7 0.397-0.967 1.265-0.608 1.978l1.758 3.447c0.254 0.504 0.789 0.831 1.362 0.831h1.831v7.5c0 0.827 0.687 1.5 1.531 1.5h10.715c0.844 0 1.531-0.673 1.531-1.5v-7.501h1.829c0.583 0 1.105-0.318 1.362-0.827l1.761-3.453c0.359-0.711 0.092-1.578-0.612-1.978h-0.001zM3.288 10.5l-1.757-3.445v-0.009l3.581-2.003v5.458h-1.823zM17.357 19.499h-10.715v-14.999h1.607c0.356 1.709 1.902 3 3.75 3s3.394-1.291 3.75-3h1.607v14.999zM20.712 10.5h-1.823v-5.458l3.577 2.001c0 0 0.006 0.008 0.005 0.009l-1.759 3.448h0.001z"></path></svg></div>
<!-- /wp:ainoblocks/icon -->

<!-- wp:paragraph {"align":"center","fontSize":"text-xs","paddingTop":4} -->
<p class="has-text-align-center has-text-xs-font-size pt__4"><?php echo esc_html_x( 'Click & Collect', 'sample content for Icon with text', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":10,"gridColumnEndDesktop":13,"gridColumnStartTablet":10,"gridColumnEndTablet":13,"gridColumnStartMobile":7,"alignItem":"center","justifyItem":"stretch","marginTopTablet":0,"marginTopMobile":4,"paddingBottom":1} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__10 col_end_d__13 col_start_t__10 col_end_t__13 col_start_m__7 col_end_m__13 align-self__center justify-self__stretch no-stacking mt_t__0 mt_m__4 pb__1"><!-- wp:ainoblocks/icon {"iconType":"Lifebuoy","iconSize":"size-s","alignment":"center"} -->
<div class="wp-block-ainoblocks-icon Lifebuoy size-s center"><svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M12 3.75c-4.556 0-8.25 3.694-8.25 8.25s3.694 8.25 8.25 8.25c4.556 0 8.25-3.694 8.25-8.25s-3.694-8.25-8.25-8.25zM2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75c0 5.385-4.365 9.75-9.75 9.75s-9.75-4.365-9.75-9.75z"></path><path d="M12 9c-1.657 0-3 1.343-3 3s1.343 3 3 3c1.657 0 3-1.343 3-3s-1.343-3-3-3zM7.5 12c0-2.485 2.015-4.5 4.5-4.5s4.5 2.015 4.5 4.5c0 2.485-2.015 4.5-4.5 4.5s-4.5-2.015-4.5-4.5z"></path><path d="M5.104 5.104c0.293-0.293 0.768-0.293 1.061 0l3.712 3.712c0.293 0.293 0.293 0.768 0 1.061s-0.768 0.293-1.061 0l-3.713-3.713c-0.293-0.293-0.293-0.768 0-1.061z"></path><path d="M18.896 5.104c0.293 0.293 0.293 0.768 0 1.061l-3.712 3.713c-0.293 0.293-0.768 0.293-1.061 0s-0.293-0.768 0-1.061l3.712-3.712c0.293-0.293 0.768-0.293 1.061 0z"></path><path d="M14.123 14.123c0.293-0.293 0.768-0.293 1.061 0l3.712 3.712c0.293 0.293 0.293 0.768 0 1.061s-0.768 0.293-1.061 0l-3.712-3.713c-0.293-0.293-0.293-0.768 0-1.061z"></path><path d="M9.877 14.123c0.293 0.293 0.293 0.768 0 1.061l-3.713 3.713c-0.293 0.293-0.768 0.293-1.061 0s-0.293-0.768 0-1.061l3.712-3.712c0.293-0.293 0.768-0.293 1.061 0z"></path></svg></div>
<!-- /wp:ainoblocks/icon -->

<!-- wp:paragraph {"align":"center","fontSize":"text-xs","paddingTop":4} -->
<p class="has-text-align-center has-text-xs-font-size pt__4"><?php echo esc_html_x( 'Expert Advise', 'sample content for Icon with text', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container -->
</div><!-- /wp:group -->