<?php
/**
 * Title: Shop Footer (default)
 * Slug: theme/footer-shop-default
 * Categories: footers
 * Block Types: core/template-part/footer
 */
?>

<!-- wp:group {"align":"full","backgroundColor":"background-secondary","className":"site-footer"} -->
<div class="wp-block-group alignfull site-footer has-background-secondary-background-color has-background">

<!-- wp:group {"className":"btn-rounded form-rounded btn-s form-s","layout":{"contentSize":"432px","type":"constrained"},"paddingTop":10,"paddingBottom":10} -->
<div class="wp-block-group btn-rounded form-rounded btn-s form-s pt__10 pb__10"><!-- wp:heading {"textAlign":"center","level":4,"style":{"typography":{"lineHeight":"1.5"}},"textColor":"font-primary","fontSize":"text-xs","paddingTop":1,"paddingBottom":6} -->
<h4 class="has-text-align-center has-font-primary-color has-text-color has-text-xs-font-size pt__1 pb__6" style="line-height:1.5"><strong><?php echo esc_html_x( 'Our monthly newsletter', 'sample content for newsletter heading', 'mugistore' ); ?></strong></h4>
<!-- /wp:heading -->

<!-- wp:mailchimp-for-wp/form {"id":5717} /--></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-s","paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-s pb__10"><!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":13,"gridColumnStartTablet":1,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"stretch","marginBottomDesktop":0,"marginBottomTablet":0,"marginBottomMobile":0,"className":"align-self__start btn-rounded form-rounded","paddingBottom":10} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking mb_d__0 mb_t__0 mb_m__0 align-self__start btn-rounded form-rounded pb__10"><!-- wp:separator {"backgroundColor":"border-secondary","className":"has-border-secondary-background-color has-background is-style-wide"} -->
<hr class="wp-block-separator has-text-color has-border-secondary-color has-alpha-channel-opacity has-border-secondary-background-color has-background is-style-wide"/>
<!-- /wp:separator --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":4,"gridColumnStartTablet":1,"gridColumnEndTablet":4,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"stretch","marginBottomDesktop":0,"marginBottomTablet":10,"marginBottomMobile":8,"className":"align-self__start"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__4 col_start_t__1 col_end_t__4 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking mb_d__0 mb_t__10 mb_m__8 align-self__start"><!-- wp:heading {"level":4,"style":{"typography":{"lineHeight":"1.5"}},"textColor":"font-primary","fontSize":"text-xs","paddingBottom":6} -->
<h4 class="has-font-primary-color has-text-color has-text-xs-font-size pb__6" style="line-height:1.5"><strong><?php echo esc_html_x( 'Shop', 'sample content for footer heading', 'mugistore' ); ?></strong></h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":1,"paddingBottom":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__1 pb__1"><a href="#"><?php echo esc_html_x( 'About us', 'sample content for footer link', 'mugistore' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":6,"paddingBottom":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__6 pb__1"><?php echo esc_html_x( 'Our Team', 'sample content for footer link', 'mugistore' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":6,"paddingBottom":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__6 pb__1"><?php echo esc_html_x( 'Services', 'sample content for footer link', 'mugistore' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":4,"gridColumnEndDesktop":7,"gridColumnStartTablet":4,"gridColumnEndTablet":7,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"stretch","marginBottomTablet":0,"marginBottomMobile":10,"className":"align-self__start"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__4 col_end_d__7 col_start_t__4 col_end_t__7 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking mb_t__0 mb_m__10 align-self__start"><!-- wp:heading {"level":4,"style":{"typography":{"lineHeight":"1.5"}},"textColor":"font-primary","fontSize":"text-xs","paddingBottom":6} -->
<h4 class="has-font-primary-color has-text-color has-text-xs-font-size pb__6" style="line-height:1.5"><strong><?php echo esc_html_x( 'Company', 'sample content for footer heading', 'mugistore' ); ?></strong></h4>
<!-- /wp:heading -->

<!-- wp:navigation {"ref":18639,"textColor":"font-secondary","overlayMenu":"never","layout":{"type":"flex","orientation":"vertical","flexWrap":"nowrap"},"style":{"spacing":{"blockGap":"1.5rem"}},"fontSize":"text-xs"} /--></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":7,"gridColumnEndDesktop":10,"gridColumnStartTablet":7,"gridColumnEndTablet":10,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"stretch","marginBottomTablet":0,"marginBottomMobile":7,"className":"align-self__start"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__7 col_end_d__10 col_start_t__7 col_end_t__10 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking mb_t__0 mb_m__7 align-self__start"><!-- wp:heading {"level":4,"style":{"typography":{"lineHeight":"1.5"}},"textColor":"font-primary","fontSize":"text-xs","paddingBottom":6} -->
<h4 class="has-font-primary-color has-text-color has-text-xs-font-size pb__6" style="line-height:1.5"><strong><?php echo esc_html_x( 'Support', 'sample content for footer heading', 'mugistore' ); ?></strong></h4>
<!-- /wp:heading -->

<!-- wp:ainoblocks/flexbox {"alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__flexstart__d justify__flexstart__t justify__flexstart__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":1,"paddingBottom":1,"paddingRight":2} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__1 pb__1 pr__2"><a href="#"><?php echo esc_html_x( 'Help Center', 'sample content for footer link', 'mugistore' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:ainoblocks/badge {"content":"New","size":"size__xs","backgroundColor":"accent-primary","fontSize":"text-xxxs","style":{"border":{"radius":"50px"}},"textColor":"button-color-primary"} -->
<div class="wp-block-ainoblocks-badge size__xs has-button-color-primary-color has-accent-primary-background-color has-text-color has-background has-text-xxxs-font-size" style="border-radius:50px"><span><?php echo esc_html_x( 'New', 'sample content for badge', 'mugistore' ); ?></span></div>
<!-- /wp:ainoblocks/badge --></div>
<!-- /wp:ainoblocks/flexbox -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":6,"paddingBottom":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__6 pb__1"><a href="#"><?php echo esc_html_x( 'Shipping and Returns', 'sample content for footer link', 'mugistore' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":6,"paddingBottom":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__6 pb__1"><a href="#"><?php echo esc_html_x( 'Track Order', 'sample content for footer link', 'mugistore' ); ?></a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xs","paddingTop":6,"paddingBottom":1} -->
<p class="has-font-secondary-color has-text-color has-text-xs-font-size pt__6 pb__1"><a href="#"><?php echo esc_html_x( 'Contact us', 'sample content for footer link', 'mugistore' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":10,"gridColumnEndDesktop":13,"gridColumnStartTablet":10,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"start","marginBottomTablet":0,"marginBottomMobile":7,"className":"align-self__start"} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__10 col_end_d__13 col_start_t__10 col_end_t__13 col_start_m__1 col_end_m__13 justify-self__start no-stacking mb_t__0 mb_m__7 align-self__start"><!-- wp:heading {"level":4,"style":{"typography":{"lineHeight":"1.5"}},"textColor":"font-primary","fontSize":"text-xs","paddingBottom":6} -->
<h4 class="has-font-primary-color has-text-color has-text-xs-font-size pb__6" style="line-height:1.5"><strong><?php echo esc_html_x( 'Follow us', 'sample content for social links heading', 'mugistore' ); ?></strong></h4>
<!-- /wp:heading -->

<!-- wp:social-links {"iconColor":"font-secondary","iconColorValue":"#1E1E1E","style":{"spacing":{"blockGap":{"left":"12px"}}},"className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"left","flexWrap":"nowrap"}} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"https://twitter.com/","service":"twitter"} /-->

<!-- wp:social-link {"url":"https://www.instagram.com/","service":"instagram"} /-->

<!-- wp:social-link {"url":"https://github.com/","service":"github"} /-->

<!-- wp:social-link {"url":"https://www.youtube.com/","service":"youtube"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":7,"gridColumnEndDesktop":13,"gridColumnStartTablet":1,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"center","justifyItem":"stretch","marginTopDesktop":0,"marginTopMobile":0,"paddingTop":13} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__7 col_end_d__13 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 align-self__center justify-self__stretch no-stacking mt_d__0 mt_m__0 pt__13"><!-- wp:ainoblocks/flexbox {"justifyContentDesktop":"justify__flexend__d","alignItemsDesktop":"align-items__center__d","alignItemsTablet":"align-items__center__t","alignItemsMobile":"align-items__center__m"} -->
<div class="wp-block-ainoblocks-flexbox direction__row__d direction__row__t direction__row__m nowrap__d nowrap_t nowrap_m justify__flexend__d justify__flexstart__t justify__flexstart__m align-items__center__d align-items__center__t align-items__center__m align-cont__stretch__d align-cont__stretch__t align-cont__stretch__m shadow-none"><!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"visaColor","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon visaColor size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path fill="#1434cb" d="M15.844 10.995l-2.138 9.995h-2.586l2.138-9.995h2.586zM26.723 17.449l1.361-3.753 0.783 3.753h-2.144zM29.609 20.99h2.391l-2.089-9.995h-2.206c-0.497 0-0.916 0.288-1.102 0.733l-3.88 9.262h2.716l0.539-1.493h3.317l0.313 1.493zM22.859 17.727c0.011-2.638-3.647-2.784-3.622-3.963 0.008-0.358 0.35-0.74 1.096-0.837 0.37-0.048 1.392-0.086 2.55 0.447l0.453-2.12c-0.622-0.225-1.423-0.442-2.419-0.442-2.556 0-4.354 1.358-4.369 3.304-0.016 1.439 1.285 2.241 2.263 2.721 1.008 0.49 1.346 0.804 1.341 1.242-0.007 0.671-0.804 0.968-1.546 0.979-1.301 0.020-2.055-0.352-2.656-0.632l-0.469 2.191c0.605 0.277 1.72 0.518 2.875 0.53 2.718 0 4.494-1.342 4.503-3.42zM12.149 10.995l-4.19 9.995h-2.733l-2.062-7.977c-0.125-0.491-0.234-0.671-0.614-0.878-0.622-0.338-1.648-0.654-2.551-0.85l0.061-0.29h4.4c0.56 0 1.065 0.373 1.193 1.019l1.089 5.784 2.69-6.803h2.717z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"applepay","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon applepay size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M5.847 11.131c-0.375 0.444-0.975 0.794-1.575 0.744-0.075-0.6 0.219-1.238 0.563-1.631 0.375-0.456 1.031-0.781 1.563-0.806 0.063 0.625-0.181 1.238-0.55 1.694zM6.391 11.994c-0.869-0.050-1.613 0.494-2.025 0.494-0.419 0-1.050-0.469-1.738-0.456-0.894 0.013-1.725 0.519-2.182 1.325-0.938 1.613-0.244 4 0.663 5.313 0.444 0.65 0.975 1.363 1.675 1.338 0.663-0.025 0.925-0.431 1.725-0.431 0.806 0 1.038 0.431 1.738 0.419 0.725-0.012 1.181-0.65 1.625-1.3 0.506-0.738 0.713-1.456 0.725-1.494-0.013-0.012-1.4-0.544-1.413-2.144-0.013-1.338 1.094-1.975 1.144-2.013-0.625-0.925-1.6-1.025-1.938-1.050zM11.41 10.181v9.745h1.513v-3.332h2.094c1.913 0 3.257-1.313 3.257-3.213s-1.319-3.2-3.207-3.2h-3.657zM12.923 11.456h1.744c1.313 0 2.063 0.7 2.063 1.931s-0.75 1.938-2.069 1.938h-1.738v-3.869zM21.036 20.001c0.95 0 1.831-0.481 2.231-1.244h0.031v1.169h1.4v-4.851c0-1.406-1.125-2.313-2.857-2.313-1.606 0-2.794 0.919-2.838 2.182h1.363c0.113-0.6 0.669-0.994 1.431-0.994 0.925 0 1.444 0.431 1.444 1.225v0.538l-1.888 0.113c-1.756 0.106-2.707 0.825-2.707 2.075 0 1.263 0.981 2.1 2.388 2.1zM21.443 18.845c-0.806 0-1.319-0.388-1.319-0.981 0-0.613 0.494-0.969 1.438-1.025l1.681-0.106v0.55c0 0.913-0.775 1.563-1.8 1.563zM26.568 22.577c1.475 0 2.169-0.563 2.775-2.269l2.657-7.451h-1.538l-1.781 5.757h-0.031l-1.781-5.757h-1.581l2.563 7.095-0.138 0.431c-0.231 0.731-0.606 1.013-1.275 1.013-0.119 0-0.35-0.013-0.444-0.025v1.169c0.088 0.025 0.463 0.038 0.575 0.038z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"paypalColor","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon paypalColor size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path fill="#253b80" d="M12.34 25.322l0.347-2.202-0.772-0.018h-3.687l2.562-16.246c0.008-0.049 0.034-0.095 0.072-0.127s0.086-0.050 0.137-0.050h6.217c2.064 0 3.488 0.429 4.232 1.277 0.349 0.398 0.571 0.813 0.678 1.271 0.113 0.48 0.115 1.053 0.005 1.752l-0.008 0.051v0.448l0.349 0.197c0.294 0.156 0.527 0.334 0.706 0.538 0.298 0.34 0.491 0.772 0.573 1.284 0.084 0.527 0.056 1.154-0.081 1.864-0.159 0.817-0.416 1.528-0.764 2.11-0.319 0.536-0.726 0.981-1.21 1.326-0.461 0.327-1.009 0.576-1.629 0.735-0.6 0.156-1.285 0.235-2.036 0.235h-0.484c-0.346 0-0.682 0.125-0.946 0.348-0.264 0.228-0.439 0.54-0.493 0.88l-0.036 0.198-0.612 3.88-0.028 0.142c-0.007 0.045-0.020 0.068-0.038 0.083-0.017 0.014-0.040 0.023-0.064 0.023h-2.987z"></path><path fill="#179bd7" d="M22.8 11.081c-0.019 0.119-0.040 0.24-0.064 0.365-0.82 4.209-3.625 5.663-7.207 5.663h-1.824c-0.438 0-0.807 0.318-0.876 0.75l-0.934 5.922-0.264 1.679c-0.044 0.284 0.174 0.539 0.461 0.539h3.235c0.383 0 0.709-0.278 0.769-0.656l0.032-0.164 0.609-3.865 0.039-0.212c0.060-0.379 0.386-0.657 0.769-0.657h0.484c3.134 0 5.588-1.273 6.305-4.955 0.3-1.538 0.145-2.823-0.648-3.726-0.24-0.272-0.538-0.498-0.885-0.683z"></path><path fill="#222d65" d="M21.942 10.739c-0.125-0.036-0.254-0.070-0.387-0.099s-0.27-0.055-0.41-0.078c-0.492-0.080-1.031-0.117-1.608-0.117h-4.873c-0.12 0-0.234 0.027-0.336 0.076-0.225 0.108-0.392 0.321-0.432 0.581l-1.037 6.565-0.030 0.192c0.068-0.432 0.437-0.75 0.875-0.75h1.824c3.582 0 6.387-1.455 7.207-5.663 0.025-0.125 0.045-0.246 0.064-0.365-0.207-0.11-0.432-0.204-0.674-0.284-0.060-0.020-0.121-0.039-0.184-0.058z"></path><path fill="#253b80" d="M13.896 11.103c0.040-0.26 0.207-0.473 0.432-0.581 0.103-0.049 0.216-0.076 0.336-0.076h4.873c0.577 0 1.116 0.038 1.608 0.117 0.141 0.023 0.277 0.048 0.41 0.078s0.262 0.063 0.387 0.099c0.062 0.019 0.124 0.038 0.184 0.057 0.242 0.080 0.467 0.175 0.674 0.284 0.244-1.555-0.002-2.615-0.843-3.574-0.927-1.056-2.601-1.508-4.742-1.508h-6.217c-0.437 0-0.811 0.318-0.878 0.751l-2.589 16.413c-0.051 0.325 0.199 0.618 0.527 0.618h3.838l0.964-6.114 1.037-6.565z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"mastercardColor","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon mastercardColor size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path fill="#ff5f00" d="M19.606 9.761h-7.211v12.958h7.211v-12.958z"></path><path fill="#eb001b" d="M12.853 16.241c-0.001-1.248 0.282-2.48 0.827-3.602s1.339-2.106 2.321-2.877c-1.216-0.956-2.676-1.55-4.213-1.715s-3.090 0.106-4.481 0.782c-1.391 0.676-2.563 1.729-3.384 3.040s-1.255 2.826-1.255 4.372c0 1.546 0.435 3.061 1.255 4.372s1.993 2.364 3.384 3.040c1.391 0.676 2.944 0.947 4.481 0.782s2.997-0.759 4.213-1.715c-0.982-0.77-1.775-1.754-2.321-2.877s-0.828-2.354-0.827-3.602z"></path><path fill="#f79e1b" d="M29.333 16.241c0 1.546-0.435 3.061-1.255 4.372s-1.993 2.364-3.384 3.040c-1.391 0.676-2.944 0.947-4.481 0.782s-2.997-0.759-4.213-1.715c0.981-0.771 1.774-1.755 2.319-2.877s0.829-2.354 0.829-3.602-0.283-2.479-0.829-3.602c-0.545-1.122-1.338-2.106-2.319-2.877 1.216-0.956 2.676-1.55 4.213-1.715s3.090 0.106 4.481 0.782c1.391 0.676 2.563 1.729 3.384 3.040s1.255 2.826 1.255 4.372z"></path><path fill="#f79e1b" d="M28.547 21.347v-0.265h0.107v-0.054h-0.272v0.054h0.107v0.265h0.058zM29.076 21.347v-0.32h-0.084l-0.096 0.22-0.096-0.22h-0.084v0.32h0.059v-0.241l0.090 0.208h0.061l0.090-0.209v0.242h0.059z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"dinersclubColor","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon dinersclubColor size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path fill="#fffffe" d="M5.085 16.173c0-5.332 4.323-9.655 9.655-9.655s9.655 4.323 9.655 9.655-4.323 9.655-9.655 9.655c-5.332 0-9.655-4.323-9.655-9.655z"></path><path fill="#0069aa" d="M20.579 15.983c-0.004-2.472-1.549-4.581-3.727-5.416v10.832c2.178-0.836 3.723-2.943 3.727-5.416zM12.698 21.396v-10.829c-2.176 0.838-3.719 2.943-3.725 5.415 0.006 2.471 1.549 4.577 3.725 5.414zM14.776 6.827c-5.056 0.002-9.153 4.099-9.154 9.156 0.001 5.056 4.097 9.152 9.154 9.153 5.056-0.001 9.154-4.098 9.155-9.153-0.001-5.056-4.099-9.154-9.155-9.156zM14.754 26c-5.533 0.026-10.087-4.456-10.087-9.913 0-5.963 4.554-10.088 10.087-10.087h2.593c5.468-0.001 10.458 4.122 10.458 10.087 0 5.455-4.99 9.913-10.458 9.913h-2.593z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"googlepayColor","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon googlepayColor size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path fill="#ea4335" d="M25.338 9.87c-2.317-1.338-5.28-0.543-6.62 1.774l-3.376 5.848c-0.977 1.689 0.281 2.279 1.683 3.119l3.248 1.875c1.1 0.634 2.505 0.258 3.139-0.841l3.47-6.010c1.166-2.019 0.474-4.6-1.545-5.766z"></path><path fill="#fbbc04" d="M21.518 12.29l-3.248-1.875c-1.793-0.995-2.809-1.061-3.545 0.109l-4.791 8.297c-1.338 2.316-0.541 5.278 1.774 6.612 2.019 1.166 4.6 0.474 5.766-1.545l4.882-8.457c0.637-1.1 0.261-2.506-0.839-3.141z"></path><path fill="#34a853" d="M22.143 8.025l-2.282-1.318c-2.523-1.457-5.75-0.593-7.207 1.931l-4.344 7.523c-0.642 1.11-0.261 2.531 0.849 3.171l2.555 1.475c1.262 0.729 2.874 0.296 3.603-0.965l4.963-8.595c1.028-1.78 3.304-2.39 5.084-1.362l-3.222-1.86z"></path><path fill="#4285f4" d="M13.272 10.791l-2.466-1.421c-1.1-0.633-2.505-0.258-3.139 0.839l-2.959 5.113c-1.457 2.516-0.593 5.736 1.931 7.188l5.143 2.962c-1.754-1.174-2.312-3.527-1.239-5.381l3.572-6.171c0.633-1.094 0.256-2.496-0.842-3.129z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item -->

<!-- wp:ainoblocks/flex-item {"paddingLeft":3} -->
<div class="wp-block-ainoblocks-flex-item auto pl__3"><!-- wp:ainoblocks/card {"borderColor":"border-secondary","borderRadius":"xxs","paddingTop":0,"paddingBottom":0,"paddingLeft":3,"paddingRight":3,"borderTopWidth":1,"borderRightWidth":1,"borderBottomWidth":1,"borderLeftWidth":1,"style":{"border":{"width":"1px"}}} -->
<div class="wp-block-ainoblocks-card shadow-none pl__3 pr__3 has-border-color has-border-secondary-border-color br-all__xxs" style="border-width:1px;border-top-width:1px;border-right-width:1px;border-bottom-width:1px;border-left-width:1px"><!-- wp:ainoblocks/icon {"iconType":"discover","iconSize":"size-s"} -->
<div class="wp-block-ainoblocks-icon discover size-s"><svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M12.57 18.542c-1.517 0-2.696-1.113-2.696-2.55 0-1.419 1.208-2.554 2.716-2.554 0.431 0 0.789 0.087 1.226 0.299v1.121c-0.413-0.389-0.774-0.549-1.246-0.549-0.936 0-1.669 0.741-1.669 1.677 0 0.99 0.71 1.684 1.712 1.684 0.453 0 0.803-0.151 1.202-0.535v1.123c-0.452 0.204-0.818 0.285-1.246 0.285z"></path><path d="M8.091 15.42c-0.599-0.21-0.774-0.35-0.774-0.614 0-0.307 0.313-0.54 0.743-0.54 0.298 0 0.544 0.114 0.805 0.393l0.518-0.65c-0.428-0.36-0.94-0.543-1.499-0.543-0.904 0-1.592 0.601-1.592 1.397 0 0.675 0.32 1.018 1.254 1.343 0.391 0.13 0.589 0.219 0.689 0.279 0.199 0.123 0.298 0.3 0.298 0.503 0 0.397-0.329 0.69-0.774 0.69-0.474 0-0.857-0.227-1.086-0.653l-0.642 0.595c0.459 0.643 1.009 0.931 1.767 0.931 1.034 0 1.762-0.662 1.762-1.605 0-0.777-0.338-1.129-1.47-1.526z"></path><path d="M0 13.548h1.463c1.614 0 2.74 1.002 2.74 2.444 0 0.72-0.345 1.416-0.927 1.876-0.49 0.389-1.048 0.565-1.822 0.565h-1.454v-4.885zM1.264 17.605c0.644 0 1.047-0.118 1.364-0.389 0.343-0.292 0.549-0.761 0.549-1.231 0-0.469-0.206-0.922-0.549-1.215-0.332-0.284-0.72-0.395-1.364-0.395h-0.267v3.23h0.267z"></path><path d="M5.654 13.548h-0.992v4.885h0.992v-4.885z"></path><path d="M21.882 16.828l-1.361-3.28h-1.086l2.164 5.009h0.534l2.206-5.009h-1.077l-1.38 3.28z"></path><path d="M27.615 18.433h-2.823v-4.885h2.823v0.827h-1.827v1.084h1.758v0.828h-1.758v1.319h1.827v0.828z"></path><path d="M31.556 14.989c0-0.915-0.656-1.441-1.805-1.441h-1.479v4.885h0.998v-1.964h0.129l1.376 1.964h1.225l-1.606-2.059c0.751-0.147 1.162-0.637 1.162-1.385zM29.559 15.794h-0.289v-1.478h0.305c0.622 0 0.955 0.25 0.955 0.726 0 0.489-0.333 0.752-0.972 0.752z"></path><path d="M16.914 18.55c1.47 0 2.661-1.14 2.661-2.547s-1.191-2.547-2.661-2.547c-1.47 0-2.661 1.14-2.661 2.547s1.191 2.547 2.661 2.547z"></path></svg></div>
<!-- /wp:ainoblocks/icon --></div>
<!-- /wp:ainoblocks/card --></div>
<!-- /wp:ainoblocks/flex-item --></div>
<!-- /wp:ainoblocks/flexbox --></div>
<!-- /wp:ainoblocks/grid-item -->

<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":7,"gridColumnStartTablet":1,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"center","justifyItem":"stretch","marginTopDesktop":10,"paddingTop":8} -->
<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__7 col_start_t__1 col_end_t__13 col_start_m__1 col_end_m__13 align-self__center justify-self__stretch no-stacking mt_d__10 pt__8"><!-- wp:paragraph {"textColor":"font-secondary","fontSize":"text-xxxs","paddingTop":0,"paddingBottom":1,"paddingRight":8} -->
<p class="has-font-secondary-color has-text-color has-text-xxxs-font-size pb__1 pr__8"><?php echo esc_html_x( '©2022', 'sample content for copyright', 'mugistore' ); ?><strong><?php echo esc_html_x( ' Your name', 'sample content for site title', 'mugistore' ); ?></strong>.
<?php
	printf(
		/* Translators: WordPress link. */
		esc_html__( 'Proudly powered by %s', 'mugistore' ),
		'<a href="' . esc_url( __( 'https://wordpress.org', 'mugistore' ) ) . '" rel="nofollow">WordPress</a>'
	)
?>
<?php
	printf(
		/* Translators: WordPress link. */
		esc_html__( '. Built with by %s', 'mugistore' ),
		'<a href="' . esc_url( __( 'https://ainoblocks.io/', 'mugistore' ) ) . '" rel="nofollow">AinoBlocks</a>'
	)
?>
</p>
<!-- /wp:paragraph --></div>
<!-- /wp:ainoblocks/grid-item --></div>
<!-- /wp:ainoblocks/grid-container --></div>
<!-- /wp:group -->
</div>
<!-- /wp:group -->