<?php
/**
 * Three Columns Cards Grid, variant
 */

return array(
	'title'      => __( 'Three Columns Cards Grid, variant' ),
	'categories' => array( 'features' ),
	'content'    => '<!-- wp:group {"align":"full","backgroundColor":"variant-background-secondary","layout":{"inherit":false},"paddingBottom":16,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-group alignfull has-variant-background-secondary-background-color has-background pb__16 pl__10 pr__10" id="skills"><!-- wp:ainoblocks/grid-container {"columnGap":"col-gap-m","paddingTop":16} -->
	<div class="wp-block-ainoblocks-grid-container alignwide ab-grid-block col-gap-m pt__16" id="skills"><!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":4,"gridColumnEndDesktop":10,"gridColumnStartTablet":3,"gridColumnEndTablet":11,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"justifyItem":"stretch","className":"as__start as__t__start js__stretch js__t__start","paddingBottom":13} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__4 col_end_d__10 col_start_t__3 col_end_t__11 col_start_m__1 col_end_m__13 justify-self__stretch no-stacking as__start as__t__start js__stretch js__t__start pb__13"><!-- wp:heading {"textAlign":"center","textColor":"variant-tertiary","className":"serif","fontSize":"text-4-xl"} -->
	<h2 class="has-text-align-center serif has-variant-tertiary-color has-text-color has-text-4-xl-font-size"><em>My Skills</em></h2>
	<!-- /wp:heading -->
	
	<!-- wp:heading {"textAlign":"center","textColor":"variant-font-primary","fontSize":"text-4-xl","paddingTop":3} -->
	<h2 class="has-text-align-center has-variant-font-primary-color has-text-color has-text-4-xl-font-size pt__3">and Toolset</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"align":"center","textColor":"variant-font-secondary","fontSize":"text-l","paddingTop":7} -->
	<p class="has-text-align-center has-variant-font-secondary-color has-text-color has-text-l-font-size pt__7">I offer a wide range of services for website projects.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/grid-item -->
	
	<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":5,"gridColumnStartTablet":1,"gridColumnEndTablet":5,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","style":{"border":{"width":"1px"}},"borderColor":"variant-border-secondary","gradient":"gradient-tertiary","className":"align-self__stretch justify-self__stretch","borderRadius":"s"} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__5 col_start_t__1 col_end_t__5 col_start_m__1 col_end_m__13 as__stretch as__t__start js__stretch js__t__start no-stacking align-self__stretch justify-self__stretch has-border-color has-variant-border-secondary-border-color has-gradient-tertiary-gradient-background has-background br-all__s" style="border-width:1px"><!-- wp:ainoblocks/card {"borderRadius":"s","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__s"><!-- wp:image {"id":20811,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/pattern-lib/pro/icon-variant-01.png" alt="" class="wp-image-20811" width="80" height="80"/></figure>
	<!-- /wp:image -->
	
	<!-- wp:heading {"textColor":"variant-font-primary","paddingTop":7} -->
	<h2 class="has-variant-font-primary-color has-text-color pt__7" id="design">Design</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"textColor":"variant-font-secondary","paddingTop":5} -->
	<p class="has-variant-font-secondary-color has-text-color pt__5">Treat yourself with a modern, professional and unique website design.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/card --></div>
	<!-- /wp:ainoblocks/grid-item -->
	
	<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":1,"gridColumnEndDesktop":5,"gridColumnStartTablet":1,"gridColumnEndTablet":5,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopDesktop":6,"marginTopTablet":5,"marginTopMobile":4,"style":{"border":{"width":"1px"}},"borderColor":"variant-border-secondary","gradient":"gradient-tertiary","className":"align-self__stretch justify-self__stretch","borderRadius":"s","paddingTop":7} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__1 col_end_d__5 col_start_t__1 col_end_t__5 col_start_m__1 col_end_m__13 as__stretch as__t__start js__stretch js__t__start no-stacking mt_d__6 mt_t__5 mt_m__4 align-self__stretch justify-self__stretch has-border-color has-variant-border-secondary-border-color has-gradient-tertiary-gradient-background has-background br-all__s pt__7" style="border-width:1px"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__none"><!-- wp:image {"id":20814,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/pattern-lib/pro/icon-variant-04.png" alt="" class="wp-image-20814" width="80" height="80"/></figure>
	<!-- /wp:image -->
	
	<!-- wp:heading {"textColor":"variant-font-primary","paddingTop":7} -->
	<h2 class="has-variant-font-primary-color has-text-color pt__7" id="design">Maintenance</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"textColor":"variant-font-secondary","paddingTop":5} -->
	<p class="has-variant-font-secondary-color has-text-color pt__5">Choose one of my regular website maintenance plans.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/card --></div>
	<!-- /wp:ainoblocks/grid-item -->
	
	<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":5,"gridColumnEndDesktop":9,"gridColumnStartTablet":5,"gridColumnEndTablet":9,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopTablet":0,"marginTopMobile":4,"style":{"border":{"width":"1px"}},"borderColor":"variant-border-secondary","gradient":"gradient-tertiary","className":"align-self__stretch justify-self__stretch","borderRadius":"s","paddingTop":0} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__5 col_end_d__9 col_start_t__5 col_end_t__9 col_start_m__1 col_end_m__13 as__stretch as__t__start js__stretch js__t__start no-stacking mt_t__0 mt_m__4 align-self__stretch justify-self__stretch has-border-color has-variant-border-secondary-border-color has-gradient-tertiary-gradient-background has-background br-all__s" style="border-width:1px"><!-- wp:ainoblocks/card {"borderRadius":"s","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__s"><!-- wp:image {"id":20812,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/pattern-lib/pro/icon-variant-02.png" alt="" class="wp-image-20812" width="80" height="80"/></figure>
	<!-- /wp:image -->
	
	<!-- wp:heading {"textColor":"variant-font-primary","paddingTop":7} -->
	<h2 class="has-variant-font-primary-color has-text-color pt__7" id="design">Writing</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"textColor":"variant-font-secondary","paddingTop":5} -->
	<p class="has-variant-font-secondary-color has-text-color pt__5">Copy writing is not your favourite pastime? Don\'t worry, I can help you out.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/card --></div>
	<!-- /wp:ainoblocks/grid-item -->
	
	<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":5,"gridColumnEndDesktop":9,"gridColumnStartTablet":5,"gridColumnEndTablet":9,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopDesktop":6,"marginTopTablet":5,"marginTopMobile":4,"style":{"border":{"width":"1px"}},"borderColor":"variant-border-secondary","gradient":"gradient-tertiary","className":"align-self__stretch justify-self__stretch","borderRadius":"s","paddingTop":7} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__5 col_end_d__9 col_start_t__5 col_end_t__9 col_start_m__1 col_end_m__13 as__stretch as__t__start js__stretch js__t__start no-stacking mt_d__6 mt_t__5 mt_m__4 align-self__stretch justify-self__stretch has-border-color has-variant-border-secondary-border-color has-gradient-tertiary-gradient-background has-background br-all__s pt__7" style="border-width:1px"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__none"><!-- wp:image {"id":20815,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/pattern-lib/pro/icon-variant-05.png" alt="" class="wp-image-20815" width="80" height="80"/></figure>
	<!-- /wp:image -->
	
	<!-- wp:heading {"textColor":"variant-font-primary","paddingTop":7} -->
	<h2 class="has-variant-font-primary-color has-text-color pt__7" id="design">Consulting</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"textColor":"variant-font-secondary","paddingTop":5} -->
	<p class="has-variant-font-secondary-color has-text-color pt__5">My consulting sessions help you to get your ideas off the ground.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/card --></div>
	<!-- /wp:ainoblocks/grid-item -->
	
	<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":9,"gridColumnEndDesktop":13,"gridColumnStartTablet":9,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopTablet":0,"marginTopMobile":4,"style":{"border":{"width":"1px"}},"borderColor":"variant-border-secondary","gradient":"gradient-tertiary","className":"align-self__stretch justify-self__stretch","borderRadius":"s","paddingTop":0} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__9 col_end_d__13 col_start_t__9 col_end_t__13 col_start_m__1 col_end_m__13 as__stretch as__t__start js__stretch js__t__start no-stacking mt_t__0 mt_m__4 align-self__stretch justify-self__stretch has-border-color has-variant-border-secondary-border-color has-gradient-tertiary-gradient-background has-background br-all__s" style="border-width:1px"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__none"><!-- wp:image {"id":20813,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/pattern-lib/pro/icon-variant-03.png" alt="" class="wp-image-20813" width="80" height="80"/></figure>
	<!-- /wp:image -->
	
	<!-- wp:heading {"textColor":"variant-font-primary","paddingTop":7} -->
	<h2 class="has-variant-font-primary-color has-text-color pt__7" id="design">Development</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"textColor":"variant-font-secondary","paddingTop":5} -->
	<p class="has-variant-font-secondary-color has-text-color pt__5">Fast loading, clean and accessible code an absolute must-have.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/card --></div>
	<!-- /wp:ainoblocks/grid-item -->
	
	<!-- wp:ainoblocks/grid-item {"gridColumnStartDesktop":9,"gridColumnEndDesktop":13,"gridColumnStartTablet":9,"gridColumnEndTablet":13,"gridColumnStartMobile":1,"gridColumnEndMobile":13,"alignItem":"stretch","justifyItem":"stretch","marginTopDesktop":6,"marginTopTablet":5,"marginTopMobile":4,"style":{"border":{"width":"1px"}},"borderColor":"variant-border-secondary","gradient":"gradient-tertiary","className":"align-self__stretch justify-self__stretch","borderRadius":"s","paddingTop":7} -->
	<div class="wp-block-ainoblocks-grid-item col_start_d__9 col_end_d__13 col_start_t__9 col_end_t__13 col_start_m__1 col_end_m__13 as__stretch as__t__start js__stretch js__t__start no-stacking mt_d__6 mt_t__5 mt_m__4 align-self__stretch justify-self__stretch has-border-color has-variant-border-secondary-border-color has-gradient-tertiary-gradient-background has-background br-all__s pt__7" style="border-width:1px"><!-- wp:ainoblocks/card {"borderRadius":"none","paddingTop":10,"paddingBottom":10,"paddingLeft":10,"paddingRight":10} -->
	<div class="wp-block-ainoblocks-card shadow-none pt__10 pb__10 pl__10 pr__10 br-all__none"><!-- wp:image {"id":20816,"width":80,"height":80,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/pattern-lib/pro/icon-variant-06.png" alt="" class="wp-image-20816" width="80" height="80"/></figure>
	<!-- /wp:image -->
	
	<!-- wp:heading {"textColor":"variant-font-primary","paddingTop":7} -->
	<h2 class="has-variant-font-primary-color has-text-color pt__7" id="design">Marketing</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"textColor":"variant-font-secondary","paddingTop":5} -->
	<p class="has-variant-font-secondary-color has-text-color pt__5">From social media marketing to website SEO, I got you covered.</p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:ainoblocks/card --></div>
	<!-- /wp:ainoblocks/grid-item --></div>
	<!-- /wp:ainoblocks/grid-container --></div>
	<!-- /wp:group -->',
);
